/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.bonus.vo;

import java.util.Date;
import java.util.Enumeration;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.payroll.base.Bonus;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.Employee;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.base.PayrollVo;
import jp.mosp.payroll.bonus.BonusConst;


public class BonusCardVo extends PayrollVo {
	
	private static final long serialVersionUID = 3281945937471826907L;
	
	// URLACSS
	private static final String RETURN_URL = "/jsp/payroll/bonus/bonusCard.jsp";
	private static final String EXTRA_JS   = "/pub/payroll/bonus/js/bonusCard.js";
	private static final String EXTRA_CSS  = "/pub/payroll/bonus/css/bonusCard.css";
	
	
	// ʃTu^Cg
	public final String SUB_TITLE = BonusConst.TTL_BONUS_CARD;

	public static final String PRM_PLT_YEAR        = "pltYear"    ;
	public static final String PRM_PLT_MONTH       = "pltMonth"   ;
	public static final String PRM_PLT_DAY         = "pltDay"     ;

	public static final String PRM_HID_K_CODE             = "hidKCode";
	public static final String PRM_HID_TARGET_YEAR        = "hidTargetYear";
	public static final String PRM_HID_TARGET_MONTH       = "hidTargetMonth";
	public static final String PRM_HID_TARGET_DAY         = "hidTargetDay";
	public static final String PRM_HID_CALC_STATUS        = "hidCalcStatus";
	public static final String PRM_HID_SELECT_LIST_CMD    = "hidSelectListCmd";	
	public static final String PRM_TXT_CHANGE_K_CODE      = "txtChangeKCode";
	
	// v_EXg
	public String[][] aryPltYear ;
	public String[][] aryPltMonth;
	public String[][] aryPltDay;

	
	// Ə̎擾pz
	public String[][] aryStation;
	public String[][] aryPltCalcStatus;
	public  Date     payDay        ;

	private String   pltYear       = "";
	private String   pltMonth      = "";
	private String   pltDay        = "";

	public  Date     targetMonth   ;

	private String hidTargetYear	= "";
	private String hidTargetMonth	= "";
	private String hidTargetDay	= "";

	private String txtChangeKCode	= "";
	private String lblCalcStatus	= "";
	private String lblStationCode	= "";
	private String hidKCode		= "";
	
	
/****************  Mosp ***************************/	
	// tB[h
	private String lblKName		= "";
	private String lblSection		= "";
	private String lblCalcMonth	= "";
	private String kCode    = "";;
	private Date   calcMonth;
	
	// ʃ[h
	private int mode;
	
	private String[][] aryTime;
	public String[][] aryAllowance  = {
                                       {"BA001"," ","0"},
	                                   {"BA002"," ","0"},
	                                   {"BA003"," ","0"},
	                                   {"BA004"," ","0"},
	                                   {"BA005"," ","0"},
	                                   {"BA006"," ","0"},
	                                   {"BA007"," ","0"},
	                                   {"BA008"," ","0"},
	                                   {"BA009"," ","0"},
	                                   {"BA010"," ","0"},
	                                   {"BA011"," ","0"},
	                                   {"BA012"," ","0"},
	                                   {"BA013"," ","0"},
	                                   {"BA014"," ","0"},
	                                   {"BA015"," ","0"},
	                                   {"BA016"," ","0"},
	                                   {"BA017"," ","0"},
	                                   {"BA018"," ","0"},
	                                   {"BA019"," ","0"},
	                                   {"BA020"," ","0"} };

	public String[][] aryDeduction	= {
                                       {"BD001"," ","0"},
	                                   {"BD002"," ","0"},
	                                   {"BD003"," ","0"},
	                                   {"BD004"," ","0"},
	                                   {"BD005"," ","0"},
	                                   {"BD006"," ","0"},
	                                   {"BD007"," ","0"},
	                                   {"BD008"," ","0"},
	                                   {"BD009"," ","0"},
	                                   {"BD010"," ","0"},
	                                   {"BD011"," ","0"},
	                                   {"BD012"," ","0"},
	                                   {"BD013"," ","0"},
	                                   {"BD014"," ","0"},
	                                   {"BD015"," ","0"},
	                                   {"BD016"," ","0"},
	                                   {"BD017"," ","0"},
	                                   {"BD018"," ","0"},
	                                   {"BD019"," ","0"},
	                                   {"BD020"," ","0"} };

	public String[][] aryBreakdown	= { {"PB001"," ",""}};
			



	public String[][] arySum        = { 
                                       {"BS001"," ","0"},
	                                   {"BS002"," ","0"},
	                                   {"BS003"," ","0"},
	                                   {"BS004"," ","0"},
	                                   {"BS005"," ","0"},
	                                   {"BS006"," ","0"} };

			// 
	public static final int LEN_MONEY    = PayrollConst.LEN_MONEY   ;
	public static final int LEN_TIME_INT = PayrollConst.LEN_TIME_INT;
	public static final int LEN_TIME_DEC = PayrollConst.LEN_TIME_DEC;

	/**
	 * {@link PayrollVo#PayrollVo()}sB
	 */
	public BonusCardVo() {
		super();
		setRetUrl(RETURN_URL);
		setExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
	}
	
	/**
	 * NGXgp[^擾Aݒ肷B
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		txtChangeKCode       = request.getParameter(PRM_TXT_CHANGE_K_CODE     );
		hidKCode             = request.getParameter(PRM_HID_K_CODE            );
		hidTargetYear        = request.getParameter(PRM_PLT_YEAR       );
		hidTargetMonth       = request.getParameter(PRM_PLT_MONTH      );
		hidTargetDay         = request.getParameter(PRM_PLT_DAY         );
		
		for (Enumeration<?> en = request.getParameterNames(); en.hasMoreElements();) {
			String detailCode = (String)en.nextElement();
			setDetailAmount(detailCode, request.getParameter(detailCode));
		}
	}
	
	/**
	 * tB[hݒ肷B
	 * @param employee Ј
	 * @param payment  ܗ^
	 */
	public void setFields(Employee employee, Bonus bonus) {
		// lݒ
		this.lblKName     = employee.getKName      ();
		this.lblSection   = employee.getSectionName();
		this.kCode        = employee.getKCode		();
		if(bonus != null){
			this.lblCalcMonth = bonus.getCalcMonthStr();
			this.calcMonth    = bonus.getCalcMonth   ();
			// ܗ^ݒ
			aryAllowance = bonus.getAllowanceArray(false);
			aryDeduction = bonus.getDeductionArray(false);
			arySum       = bonus.getSumArray      (false);
		}
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// ÓmFI
		endValidation();
	}
	
	/**
	 * tB[hݒ肷(DTOɑ΂VÕZbg)B
	 * @param payment ܗ^
	 */
	public void setDtoFields(Bonus bonus) {
		bonus.setDetails(aryTime,aryAllowance, aryDeduction, aryBreakdown, arySum);
	}
	
	/**
	 * tB[hݒ肷(DTOɑ΂VÕZbg)B
	 * @param payment ܗ^
	 */
	public void setDtoFields2(Employee employee, Bonus bonus, Date targetMonth) {
		bonus.setDetails2(aryTime,aryAllowance, aryDeduction, aryBreakdown, arySum, employee, targetMonth);
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.payroll.base.PayrollVo#getDirectJs(Class)
	 */
	@Override
	public String getDirectJs(Class<?> cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = " + mode + ";");
	
		// xڃp[^Xg쐬
		sb.append("var ARY_ALLOWANCE = new Array(");
		for (int i = 0; i < aryAllowance.length; i++) {
			sb.append("\"" + aryAllowance[i][0] + "\", ");
		}
		if (aryAllowance.length > 0) {
			sb.delete(sb.length() - 2, sb.length());
		}
		sb.append(");");
		// Tڃp[^Xg쐬
		sb.append("var ARY_DEDUCTION = new Array(");
		for (int i = 0; i < aryDeduction.length; i++) {
			sb.append("\"" + aryDeduction[i][0] + "\", ");
		}
		if (aryDeduction.length > 0) {
			sb.delete(sb.length() - 2, sb.length());
		}
		sb.append(");");
		// 󍀖ڃp[^Xg쐬
		sb.append("var ARY_BREAKDOWN = new Array(");
		for (int i = 0; i < aryBreakdown.length; i++) {
			sb.append("\"" + aryBreakdown[i][0] + "\", ");
		}
		if (aryBreakdown.length > 0) {
			sb.delete(sb.length() - 2, sb.length());
		}
		sb.append(");");
		// vڃp[^Xg쐬
		sb.append("var ARY_SUM = new Array(");
		for (int i = 0; i < arySum.length; i++) {
			sb.append("\"" + arySum[i][0] + "\", ");
		}
		if (arySum.length > 0) {
			sb.delete(sb.length() - 2, sb.length());
		}
		sb.append(");");
		return sb.toString();
	}
	
	
	/**
	 * x׌擾B<br>
	 * @return xגl
	 */
	public int getAllowanceCount() {
		return aryAllowance.length;
	}
	
	/**
	 * T׌擾B<br>
	 * @return Tגl
	 */
	public int getDeductionCount() {
		return aryDeduction.length;
	}
	
	/**
	 * 󖾍׌擾B<br>
	 * @return 󖾍גl
	 */
	public int getBreakdownCount() {
		return aryBreakdown.length;
	}
	
	/**
	 * v׌擾B<br>
	 * @return vגl
	 */
	public int getSumCount() {
		return arySum.length;
	}
	
	/**
	 * xגl擾B<br>
	 * @param idx CfbNX
	 * @return xגl
	 */
	public String getAllowanceAmount(int idx) {
		return aryAllowance[idx][2];
	}
	
	/**
	 * Tגl擾B<br>
	 * @param idx CfbNX
	 * @return Tגl
	 */
	public String getDeductionAmount(int idx) {
		return aryDeduction[idx][2];
	}
	
	/**
	 * 󖾍גl擾B<br>
	 * @param idx CfbNX
	 * @return 󖾍גl
	 */
	public String getBreakdownAmount(int idx) {
		return aryBreakdown[idx][2];
	}
	
	/**
	 * Tגl擾B<br>
	 * @param idx CfbNX
	 * @return Tגl
	 */
	public String getSumAmount(int idx) {
		return arySum[idx][2];
	}

	
	/**
	 * x׃R[h擾B<br>
	 * @param idx CfbNX
	 * @return x׃R[h
	 */
	public String getAllowanceCode(int idx) {
		return aryAllowance[idx][0];
	}
	
	/**
	 * T׃R[h擾B<br>
	 * @param idx CfbNX
	 * @return T׃R[h
	 */
	public String getDeductionCode(int idx) {
		return aryDeduction[idx][0];
	}
	
	/**
	 * 󖾍׃R[h擾B<br>
	 * @param idx CfbNX
	 * @return 󖾍׃R[h
	 */
	public String getBreakdownCode(int idx) {
		return aryBreakdown[idx][0];
	}
	
	/**
	 * v׃R[h擾B<br>
	 * @param idx CfbNX
	 * @return v׃R[h
	 */
	public String getSumCode(int idx) {
		return arySum[idx][0];
	}
	

	/**
	 * xז̂擾B<br>
	 * @param idx CfbNX
	 * @return xז
	 */
	public String getAllowanceName(int idx) {
		return escapeHTML(aryAllowance[idx][1]);
	}
	
	/**
	 * Tז̂擾B<br>
	 * @param idx CfbNX
	 * @return Tז
	 */
	public String getDeductionName(int idx) {
		return escapeHTML(aryDeduction[idx][1]);
	}
	
	/**
	 * 󖾍ז̂擾B<br>
	 * @param idx CfbNX
	 * @return 󖾍ז
	 */
	public String getBreakdownName(int idx) {
		return escapeHTML(aryBreakdown[idx][1]);
	}
	
	/**
	 * vז̂擾B<br>
	 * @param idx CfbNX
	 * @return vז
	 */
	public String getSumName(int idx) {
		return escapeHTML(arySum[idx][1]);
	}
	
	/**
	 * vZN擾B
	 * @return vZN
	 */
	public Date getCalcMonth() {
		return getDateField(calcMonth);
	}
	
	/**
	 * vZNݒ肷B
	 * @param calcMonth ݒ肷vZN
	 */
	public void setCalcMonth(Date calcMonth) {
		this.calcMonth = getDateField(calcMonth);
	}
	
	/**
	 * vZN擾B
	 * @return vZN
	 */
	public String getEscLblCalcMonth() {
		return escapeHTML(lblCalcMonth);
	}
	
	/**
	 * vZNݒ肷B
	 * @param lblCalcMonth ݒ肷vZN
	 */
	public void setLblCalcMonth(String lblCalcMonth) {
		this.lblCalcMonth = lblCalcMonth;
	}
	
	/**
	 * ЈR[h擾B
	 * @return ЈR[h
	 */
	public String getKCode() {
		return kCode;
	}
	
	/**
	 * ЈR[h擾B
	 * @return ЈR[h
	 */
	public String getEscKCode() {
		return escapeHTML(kCode);
	}
	
	/**
	 * ЈR[hݒ肷B
	 * @param lblKCode ݒ肷ЈR[h
	 */
	public void setKCode(String lblKCode) {
		this.kCode = lblKCode;
	}
	
	/**
	 * Ј擾B
	 * @return Ј
	 */
	public String getLblKName() {
		return lblKName;
	}
	
	/**
	 * Ј擾B
	 * @return Ј
	 */
	public String getEscLblKName() {
		return escapeHTML(lblKName);
	}
	
	/**
	 * Јݒ肷B
	 * @param lblKName ݒ肷Ј
	 */
	public void setLblKName(String lblKName) {
		this.lblKName = lblKName;
	}
	
	/**
	 * 擾B
	 * @return 
	 */
	public String getEscLblSection() {
		return escapeHTML(lblSection);
	}

	/**
	 * ݒ肷B
	 * @param lblSection ݒ肷鏊
	 */
	public void setLblSection(String lblSection) {
		this.lblSection = lblSection;
	}

	/**
	 * גlݒ肷B<br>
	 * @param aryDetail  הz
	 * @param detailCode ׃R[h
	 * @param amount     גl
	 */
	private void setDetailAmount(String detailCode, String amount) {
		for (int i = 0; i < aryAllowance.length; i++) {
			if (aryAllowance[i][0].equals(detailCode)) {
				aryAllowance[i][2] = amount;
				return;
			}
		}
		for (int i = 0; i < aryDeduction.length; i++) {
			if (aryDeduction[i][0].equals(detailCode)) {
				aryDeduction[i][2] = amount;
				return;
			}
		}
		for (int i = 0; i < aryBreakdown.length; i++) {
			if (aryBreakdown[i][0].equals(detailCode)) {
				aryBreakdown[i][2] = amount;
				return;
			}
		}
		for (int i = 0; i < arySum.length; i++) {
			if (arySum[i][0].equals(detailCode)) {
				arySum[i][2] = amount;
				return;
			}
		}
	}
	
	/**
	 * ʃ[hݒ肷B<br><br>
	 * 0:o^A1Fo^s
	 * @param mode ݒ肷ʃ[h
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
	
	
	
/*******************************  Unic **************************************/	
	// ANZT\bh
	public void setHidKCode				(String hidKCode		) { this.hidKCode = hidKCode ; }
	public void setPltYear					(String pltYear			) { this.pltYear  = pltYear     ; }
	public void setPltMonth				(String pltMonth		) { this.pltMonth = pltMonth    ; }
	public void setPltDay					(String pltDay			) { this.pltDay   = pltDay      ; }
	public void setTxtChangeKCode			(String txtChangeKCode	) { this.txtChangeKCode       = txtChangeKCode      ;}

	public String getEscHidTargetYear      () { return escapeHTML(hidTargetYear       ); }
	public String getEscHidTargetMonth     () { return escapeHTML(hidTargetMonth      ); }
	public String getEscHidTargetDay       () { return escapeHTML(hidTargetDay        ); }
	public String getEscTxtChangeKCode		() { return escapeHTML(txtChangeKCode      ); }
	public String getEscLblCalcStatus		() { return escapeHTML(lblCalcStatus       ); }
	public String getEscLblStationCode		() { return escapeHTML(lblStationCode      ); }
	public String getEscLblStationName		() { return escapeHTML(lblSection      ); }
	public String getEscLblKCode			() { return escapeHTML(kCode				); }
	public String getEscHidKCode			() { return escapeHTML(hidKCode            ); }
	public String getHidKCode				() { return kCode							; }
	public String getHidTargetYear			() { return hidTargetYear					; }
	public String getHidTargetMonth			() { return hidTargetMonth					; }
	public String getHidTargetDay			() { return hidTargetDay					; }
	public String getPltYear				() { return pltYear							; }
	public String getPltMonth				() { return pltMonth						; }
	public String getPltDay					() { return pltDay							; }
	public String getTxtChangeKCode			() { return txtChangeKCode					; }


	/**
	 * Tu^Cg擾
	 * @param subTitle Tu^Cg
	 * @param cmdMenu  j[R}h
	 * @return Tu^CgHTML
	 */
	public String getSubTitle(String subTitle, String cmdMenu) {
		StringBuffer sb = new StringBuffer();
		sb.append("<div class=\"Header\">");
		sb.append("<div class=\"MenuButtonBar\">");
		sb.append("<button type=\"button\" ");
		sb.append("onclick=\"doSubmit(document.form, '");
		sb.append(cmdMenu);
		sb.append("')\">j[</button>");
		sb.append("<button type=\"button\" id=\"btnLogout\" ");
		sb.append("onclick=\"doSubmit(document.form, '");
		sb.append(MospConst.CMD_LOGOUT);
		sb.append("')\">OAEg</button>");
		sb.append("</div>");
		sb.append("<div class=\"SubTitleBar\">");
		sb.append(subTitle);
		sb.append("</div>");
		sb.append("</div>");
		return sb.toString();
	}
	
	/**
	 * ܗ^xݒ
	 * @param year
	 * @param month
	 * @param day
	 * @throws MospException
	 */
	public void setPayDay(
			String year, String month, String day
	) throws MospException {
		payDay = getDate(year, month, day);
	}
	
	/**
	 * Ώ۔Nݒ
	 * @param year
	 * @param month
	 * @throws MospException
	 */
	public void setTargetMonth(
			String year, String month
	) throws MospException {
		targetMonth = getDate(year, month, String.valueOf(BonusConst.TIME_DEFAULT_DAY));
	}
	
	
	
	
	
}

